LPARAMETERS tcFic

IF PCOUNT()<1
	tcFic="fc"
ELSE
	tcFic=IIF(LEN(tcFic)<2,tcFic+"c",tcFic)
ENDIF

LOCAL lcOldErr,lcNomTable,lcCode,lnLen,lcEcoDesig,lnEcoVal,lnEcoTot,lnTri,laTableau[1],lnI,lcBlCode,lcAlias2,lcNomTable2

glErr=.F.
lcOldErr=ON("ERROR")
ON ERROR lse_ErrEtats(ALLTRIM(STR(ERROR())),MESSAGE(),ALLTRIM(STR(LINENO())),PROGRAM(),lcOldErr)

DIMENSION laTableau[1]
STORE "" TO laTableau

SELECT QUERY
IF glLignesEco=.T.
	SELECT QUERY.*,RECNO()*2 AS tri FROM QUERY INTO CURSOR QUERY

	* Ajout des lignes d'co-contribution
	gcAlias=CreateUniqueAlias()
	lcNomTable=envreptem+gcAlias+".dbf"
	SELECT QUERY.* FROM QUERY WHERE (QUERY.&tcFic.eecocode<>"") AND (QUERY.&tcFic.eecoprc=.F.) INTO TABLE &lcNomTable.
	SELECT &gcAlias.

	GO TOP
	SCAN
		lcCode=&tcFic.ecode
		lnLen=LEN(lcCode)
		lcEcoDesig=&tcFic.eecodesi
		lnEcoVal=&tcFic.eecoval
		lnEcoTot=&tcFic.eecotot
		lnTri=tri+1
		IF glEcoCode=.T.
			REPLACE &tcFic.ecode 	WITH RIGHT(SPACE(lnLen)+ALLTRIM(lcCode),lnLen) ,;
				&tcFic.edesig 		WITH lcEcoDesig ,;
				&tcFic.ememod 		WITH "" ,;
				&tcFic.etype 		WITH "EC" ,;
				&tcFic.eremlig		WITH 0 ,;
				&tcFic.epuutvr		WITH 0 ,;
				&tcFic.enumep		WITH "" ,;
				&tcFic.ebtxg		WITH .F. ,;
				&tcFic.ebtxi		WITH .F. ,;
				&tcFic.ebtxs		WITH .F. ,;
				tri 				WITH lnTri
		ELSE
			REPLACE &tcFic.ecode 	WITH "" ,;
				&tcFic.edesig 		WITH lcEcoDesig ,;
				&tcFic.ememod 		WITH "" ,;
				&tcFic.etype 		WITH "EC" ,;
				&tcFic.eremlig		WITH 0 ,;
				&tcFic.epuutvr		WITH 0 ,;
				&tcFic.enumep		WITH "" ,;
				&tcFic.ebtxg		WITH .F. ,;
				&tcFic.ebtxi		WITH .F. ,;
				&tcFic.ebtxs		WITH .F. ,;
				tri 				WITH lnTri
		ENDIF
	ENDSCAN
	GO TOP

	* Ajout avec suppression des lignes de composition
	SELECT QUERY.* FROM QUERY WHERE EMPTY(&tcFic.enumep) UNION ALL SELECT &gcAlias..* FROM &gcAlias. INTO CURSOR QUERY

	* Tri des lignes
	SELECT QUERY.* FROM QUERY ORDER BY tri INTO CURSOR QUERY
ELSE
	SELECT QUERY
	IF TYPE("&tcFic.elcgcode")!="U"
		GO BOTTOM
		SKIP -1
		lcBlCode=fcelcgcode
		GO TOP
	ENDIF

	* Ajout des lignes d'co-contribution
	lnTri=90000
	gcAlias=CreateUniqueAlias()
	lcNomTable=envreptem+gcAlias+".dbf"
	SELECT QUERY.* FROM QUERY WHERE (QUERY.&tcFic.eecocode<>"") AND (QUERY.&tcFic.eecoprc=.F.) INTO TABLE &lcNomTable.
	SELECT &gcAlias.
	GO TOP
	SCAN
		lcCode=&tcFic.eecocode
		lnLen=LEN(lcCode)
		lcEcoDesig=&tcFic.eecodesi
		lnEcoVal=&tcFic.eecoval
		lnEcoTot=&tcFic.eecotot
		IF TYPE("&tcFic.elcgcode")="U"
			REPLACE &tcFic.ecode 	WITH RIGHT(SPACE(lnLen)+ALLTRIM(lcCode),lnLen) ,;
				&tcFic.edesig 		WITH lcEcoDesig ,;
				&tcFic.ememod 		WITH "" ,;
				&tcFic.etype 		WITH "EC" ,;
				&tcFic.eremlig		WITH 0 ,;
				&tcFic.epuutvr		WITH 0 ,;
				&tcFic.enumep		WITH "" ,;
				&tcFic.ebtxg		WITH .F. ,;
				&tcFic.ebtxi		WITH .F. ,;
				&tcFic.ebtxs		WITH .F.
		ELSE
			REPLACE &tcFic.ecode 	WITH RIGHT(SPACE(lnLen)+ALLTRIM(lcCode),lnLen) ,;
				&tcFic.edesig 		WITH lcEcoDesig ,;
				&tcFic.ememod 		WITH "" ,;
				&tcFic.etype 		WITH "EC" ,;
				&tcFic.eremlig		WITH 0 ,;
				&tcFic.epuutvr		WITH 0 ,;
				&tcFic.enumep		WITH "" ,;
				&tcFic.ebtxg		WITH .F. ,;
				&tcFic.ebtxi		WITH .F. ,;
				&tcFic.ebtxs		WITH .F. ,;
				&tcFic.elcgcode	WITH lcBlCode
		ENDIF
	ENDSCAN
	GO TOP

	SELECT &gcAlias..&tcFic.eecocode,SUM(0.000+&gcAlias..&tcFic.eqtucv),SUM(0.0000+(&gcAlias..&tcFic.eqtucv*&gcAlias..&tcFic.eecoval)) FROM &gcAlias. WHERE &gcAlias..&tcFic.etype="EC" GROUP BY &gcAlias..&tcFic.eecocode ORDER BY &gcAlias..&tcFic.eecocode INTO ARRAY laTableau
	IF ALEN(laTableau,2)>1
		FOR lnI=1 TO ALEN(laTableau,1)
			UPDATE &gcAlias. SET &gcAlias..&tcFic.eqtucv=laTableau[lnI,2],&gcAlias..&tcFic.eecotot=laTableau[lnI,3] WHERE &gcAlias..&tcFic.eecocode=laTableau[lnI,1]
		ENDFOR
	ENDIF
	lcAlias2=CreateUniqueAlias()
	lcNomTable2=envreptem+lcAlias2+".dbf"
	SELECT &gcAlias..* FROM &gcAlias. GROUP BY &gcAlias..&tcFic.ecode ORDER BY &gcAlias..&tcFic.ecode INTO TABLE &lcNomTable2.
	IF _TALLY>0
		lnTri=lnTri+1
		UPDATE &lcAlias2. SET &tcFic.enumsais=ALLTRIM(STR(lnTri+RECNO(),5,0))
		SELECT &gcAlias.
		ZAP
		APPEND FROM &lcNomTable2.
		IF glMentionEco=.T.
			SELECT &gcAlias..* FROM &gcAlias. WHERE RECNO()=1 INTO TABLE &lcNomTable2.
			SELECT &gcAlias.
			APPEND FROM &lcNomTable2.
			lnTri=lnTri+1
			IF TYPE("&tcFic.elcgcode")="U"
				REPLACE &tcFic.ecode 	WITH "" ,;
					&tcFic.edesig 		WITH "" ,;
					&tcFic.ememod		WITH gcMentionEco ,;
					&tcFic.eqtucv		WITH 0 ,;
					&tcFic.eecoval		WITH 0 ,;
					&tcFic.eecotot		WITH 0 ,;
					&tcFic.etype 		WITH "N" ,;
					&tcFic.eremlig		WITH 0 ,;
					&tcFic.epuutv		WITH 0 ,;
					&tcFic.epuutvr		WITH 0 ,;
					&tcFic.emtht		WITH 0 ,;
					&tcFic.enumep		WITH "" ,;
					&tcFic.ebtxg		WITH .F. ,;
					&tcFic.ebtxi		WITH .F. ,;
					&tcFic.ebtxs		WITH .F. ,;
					&tcFic.enumsais	WITH ALLTRIM(STR(lnTri+RECNO(),5,0))
			ELSE
				REPLACE &tcFic.ecode 	WITH "" ,;
					&tcFic.edesig 		WITH "" ,;
					&tcFic.ememod		WITH gcMentionEco ,;
					&tcFic.eqtucv		WITH 0 ,;
					&tcFic.eecoval		WITH 0 ,;
					&tcFic.eecotot		WITH 0 ,;
					&tcFic.etype 		WITH "N" ,;
					&tcFic.eremlig		WITH 0 ,;
					&tcFic.epuutv		WITH 0 ,;
					&tcFic.epuutvr		WITH 0 ,;
					&tcFic.emtht		WITH 0 ,;
					&tcFic.enumep		WITH "" ,;
					&tcFic.ebtxg		WITH .F. ,;
					&tcFic.ebtxi		WITH .F. ,;
					&tcFic.ebtxs		WITH .F. ,;
					&tcFic.elcgcode	WITH lcBlCode ,;
					&tcFic.enumsais	WITH ALLTRIM(STR(lnTri+RECNO(),5,0))

			ENDIF
		ENDIF
		SELECT &lcAlias2.
		USE
		DELETE FILE &lcNomTable2.
		DELETE FILE FORCEEXT(lcNomTable2,"fpt")
	ENDIF

	* Ajout au avec suppression des lignes de composition
	SELECT QUERY.* FROM QUERY WHERE EMPTY(&tcFic.enumep) UNION ALL SELECT &gcAlias..* FROM &gcAlias. INTO CURSOR QUERY

	* Tri des lignes
	IF TYPE("&tcFic.elcgcode")="U"
		SELECT QUERY.* FROM QUERY ORDER BY &tcFic.enumsais INTO CURSOR QUERY
	ELSE
		SELECT QUERY.* FROM QUERY ORDER BY &tcFic.elcgcode,&tcFic.enumsais INTO CURSOR QUERY
	ENDIF
ENDIF
SELECT &gcAlias.
USE
DELETE FILE &lcNomTable.
DELETE FILE FORCEEXT(lcNomTable,"fpt")

ON ERROR &lcOldErr

SELECT QUERY

RELEASE lcOldErr,lcNomTable,lcCode,lnLen,lcEcoDesig,lnEcoVal,lnEcoTot,lnTri,laTableau,lnI,lcBlCode,lcAlias2,lcNomTable2


***********************
* Gestion des erreurs *
***********************

FUNCTION lse_ErrEtats(tcErr,tcMess,tcLig,tcProg,tcOld)

	MESSAGEBOX("Programme 'V6Eco.prg' : erreur "+tcErr+CHR(13)+tcMess+CHR(13)+"Ligne "+tcLig+CHR(13)+tcProg,16,"Erreur")

	ON ERROR &tcOld

	glErr=.T.

	RETURN

ENDFUNC
