
*************************************************************************************

FUNCTION lse_Extract(tcChaine,tcDeb,tcFin)

	LOCAL lcChaine,lnPos

	lcChaine=tcChaine
	IF EMPTY(lcChaine)
		RETURN lcChaine
	ENDIF
	IF EMPTY(tcDeb)
		RETURN lcChaine
	ENDIF

	lnPos=AT(tcDeb,lcChaine)
	IF lnPos==0
		RETURN lcChaine
	ENDIF
	lcChaine=SUBSTR(lcChaine,lnPos+LEN(tcDeb))

	IF !EMPTY(tcFin)
		lnPos=AT(tcFin,lcChaine)
		IF lnPos!=0
			lcChaine=LEFT(lcChaine,lnPos-1)
		ENDIF
	ENDIF

	RETURN lcChaine

ENDFUNC

PROCEDURE lse_SuppFic(tcEtat)

	LOCAL lcTalk

	lcTalk=SYS(2001,"TALK")
	SET TALK OFF

	IF FILE(tcEtat)
		DELETE FILE (tcEtat)
	ENDIF

	SET TALK &lcTalk

ENDPROC

PROCEDURE lse_SuppFic2(tcEtat)

	LOCAL lcTalk,lcEtat

	lcTalk=SYS(2001,"TALK")
	SET TALK OFF

	lcEtat=JUSTPATH(tcEtat)+"\"+JUSTSTEM(tcEtat)
	IF FILE(lcEtat+".frx")
		DELETE FILE (lcEtat+".frx")
	ENDIF
	IF FILE(lcEtat+".frt")
		DELETE FILE (lcEtat+".frt")
	ENDIF
	IF FILE(lcEtat+".ps")
		DELETE FILE (lcEtat+".ps")
	ENDIF
	IF FILE(lcEtat+".pdf")
		DELETE FILE (lcEtat+".pdf")
	ENDIF

	SET TALK &lcTalk

ENDPROC

FUNCTION lse_EuroConv(tnNbre,tnTaux)

	tnTaux=IIF(tnTaux=0,1,tnTaux)
	RETURN ROUND(tnNbre/tnTaux,gp_pavnbdecv1)

ENDFUNC

FUNCTION lse_Ntoc(tnVal)

	IF TYPE("tnVal")=="N"
		RETURN ALLTRIM(STR(tnVal))
	ELSE
		RETURN tnVal
	ENDIF

ENDFUNC

FUNCTION lse_FormatNbre(tnNbre,tnDec)

	LOCAL lnLgInt,lcChaine,lnDec

	lcChaine=""
	lnDec=SYS(2001,"DECIMALS")
	SET DECIMALS TO 18

	lnLgInt=LEN(ALLTRIM(STR(INT(tnNbre),18)))
	lcChaine=IIF(SIGN(tnNbre)=-1,"9","")+REPLICATE("9",lnLgInt-INT(lnLgInt/3)*3)+REPLICATE(" 999",INT(lnLgInt/3))+IIF(tnDec>0,"."+REPLICATE("9",tnDec),"")
	lcChaine=ALLTRIM(TRANSFORM(tnNbre,lcChaine))

	SET DECIMALS TO &lnDec.

	RETURN lcChaine

ENDFUNC

*************************************************************************************

PROCEDURE lse_ShellExecute(tcAction,tcFichier,tcParameters,tcDir,tnShow)

	LOCAL lnHandle,lcReturn

	DECLARE INTEGER ShellExecute IN Shell32 INTEGER lnHandle,STRING tcAction,STRING tcFichier,STRING tcParameters,STRING tcDir,INTEGER tnShow

	lnHandle=0
	lnHandle=ShellExecute(lnHandle,tcAction,tcFichier,tcParameters,tcDir,tnShow)

	DO CASE
		CASE lnHandle=0
			lcReturn="La mmoire systme tait insuffisante, le fichier excutable tait endommag ou les radressages n'taient pas valides."

		CASE lnHandle=2
			lcReturn="Le fichier tait introuvable."

		CASE lnHandle=3
			lcReturn="Le chemin d'accs tait introuvable."

		CASE lnHandle=5
			lcReturn="Une tentative de liaison dynamique  une tche a t effectue ou une erreur de partage ou de protection rseau s'est produite."

		CASE lnHandle=6
			lcReturn="La bibliothque requiert des segments de donnes spars pour chaque tche."

		CASE lnHandle=8
			lcReturn="La mmoire tait insuffisante pour dmarrer l'application."

		CASE lnHandle=10
			lcReturn="La version de Windows tait incorrecte."

		CASE lnHandle=11
			lcReturn="Le fichier excutable n'tait pas valide. Soit il ne s'agissait pas d'une application Windows, soit l'image .exe comportait une erreur."

		CASE lnHandle=12
			lcReturn="L'application a t conue pour un systme d'exploitation diffrent."

		CASE lnHandle=13
			lcReturn="L'application a t conue pour MS-DOS version 4.0."

		CASE lnHandle=14
			lcReturn="Le type de fichier excutable tait inconnu."

		CASE lnHandle=15
			lcReturn="Une tentative de chargement d'une application en mode rel (dveloppe pour une version antrieure de Windows) a t effectue."

		CASE lnHandle=16
			lcReturn="Une tentative de chargement d'une deuxime instance d'un fichier excutable contenant plusieurs segments de donnes non marqus en lecture seule a t effectue."

		CASE lnHandle=19
			lcReturn="Une tentative de chargement d'un fichier excutable compress a t effectue. Le fichier doit tre dcompress avant d'tre charg."

		CASE lnHandle=20
			lcReturn="La bibliothque de liens dynamiques (DLL) N'tait pas valide. Une des DLL ncessaires  l'excution de l'application taient endommage."

		CASE lnHandle=21
			lcReturn="L'application ncessite des extensions Microsoft WINDOWS 32 BITS."

		CASE lnHandle=31
			lcReturn="L'ordre '"+tcAction+"' n'est pas compris."

		OTHERWISE
			lcReturn=""

	ENDCASE

	RETURN lcReturn

	CLEAR DLLS ShellExecute

ENDPROC

FUNCTION lse_LitIni(tcFichier,tcSection,tcCle)

	LOCAL lnOk,lcNom,lnTaille,lcReturn

	lnOk=0
	lnTaille=250
	lcNom=SPACE(lnTaille)

	DECLARE INTEGER GetPrivateProfileString IN kernel32 STRING tcSection,STRING tcCle,STRING tcDef,STRING @tcValeurCle,INTEGER tnBuff,STRING tcFichier

	lnOk=GetPrivateProfileString(tcSection,tcCle,"",@lcNom,lnTaille,tcFichier)
	lcReturn=IIF(lnOk!=0,ALLTRIM(STRTRAN(lcNom,CHR(0),"")),"")

	CLEAR DLLS GetPrivateProfileString

	RETURN lcReturn

ENDFUNC

FUNCTION lse_EcritIni(tcFichier,tcSection,tcCle,tcValeur)

	LOCAL lnOk,lcReturn

	lnOk=0
	lcReturn=""
	DECLARE LONG WritePrivateProfileString IN Kernel32 STRING tcSection,STRING tcCle,STRING tcValeur,STRING tcFichier

	lnOk=WritePrivateProfileString(tcSection,tcCle,tcValeur,tcFichier)
	IF lnOk=0
		lcReturn="Echec lors de la cration !!!"+CHR(13)+"WritePrivateProfileString("+tcSection+","+tcCle+","+tcValeur+","+tcFichier+")"
	ENDIF

	CLEAR DLLS WritePrivateProfileString

	RETURN lcReturn

ENDFUNC

FUNCTION lse_Utilisateur

	LOCAL lcNom,lnTailleChaine,lnOk,lcReturn

	lnOk=0
	lnTailleChaine=250
	lcNom=SPACE(lnTailleChaine)

	DECLARE SHORT GetUserName IN Win32API STRING @lcNom,INTEGER @lnTailleChaine

	lnOk=GetUserName(@lcNom,@lnTailleChaine)
	lcReturn=IIF(lnOk!=0,lse_chaineSup0(lcNom),"ERREUR FONCTION lse_Utilisateur")

	CLEAR DLLS GetUserName

	RETURN lcReturn

ENDFUNC

FUNCTION lse_NomOrdi

	LOCAL lcNom,lnTailleChaine,lnOk,lcReturn

	lnOk=0
	lcNom=SPACE(250)
	lnTailleChaine=250

	DECLARE SHORT GetComputerName IN Kernel32 STRING @lcNom,LONG @lnTailleChaine

	lnOk=GetComputerName(@lcNom,@lnTailleChaine)
	lcReturn=IIF(lnOk!=0,lse_chaineSup0(lcNom),"ERREUR FONCTION lse_NomOrdi")

	CLEAR DLLS GetComputerName

	RETURN lcReturn

ENDFUNC

FUNCTION lse_AdresseIp

	LOCAL lcDll,llErr,loObj,lcReturn

	* MsWinsck.ocx : Microsoft Winsock Control OCX

	IF FILE(lse_PathSystem32()+"\MsWinsck.ocx")
		llErr=.T.
		ON ERROR DO lse_ErrCreateObject WITH llErr
		loObj=CREATEOBJECT("mswinsock.winsock")
		ON ERROR DO lse_Erreur WITH PROGRAM(), LINENO()
		IF llErr==.T.
			lcReturn=loObj.LocalIP
			RELEASE loObj
		ELSE
			lcReturn=""
		ENDIF
	ELSE
		lcReturn=""
	ENDIF

	RETURN lcReturn

ENDFUNC

PROCEDURE lse_ErrCreateObject(tlErr)

	ON ERROR DO lse_Erreur WITH PROGRAM(), LINENO()

	tlErr=.F.

ENDPROC

PROCEDURE lse_Erreur

	* Paramtres	: 	-expC	nom du programme en cours d'excution
	*					-expN	numro de la ligne

	LPARAMETERS tcProgramme,tnLigne

	LOCAL ARRAY laTables(1)		&& servira  connatre les tables ouvertes
	LOCAL lcMessage,I,lcGestErreur
	LOCAL lnId,lcLect,lcEcrit,lnPos

	lcMessage=""

	* Dsactivation du gestionnaire d'erreur pour viter sur appel
	lcGestErreur=ON("error")
	ON ERROR

	PUSH KEY CLEAR

	* Constitution du message
	lcMessage = [Erreur ] + LTRIM(STR(ERROR())) + [ '] + MESSAGE() + ['] + CHR(13) + ;
		[A LA LIGNE ] + LTRIM(STR(tnLigne)) + [, programme(s) :] + CHR(13)

	* pour faciliter la localisation de l'erreur, nous allons indiquer
	* toute l'imbrication des programmes en cours
	I = 0
	DO WHILE .T.
		I = I+1
		lcMessage=lcMessage+CHR(13)+"     "+PROGRAM(I)
		IF tcProgramme==PROGRAM(I)
			EXIT
		ENDIF
	ENDDO

	MESSAGEBOX(lcMessage,16,"Une erreur est survenue :")


	* Restauration de l'environnement, retour au programme appelant
	POP KEY

	* si le programme en cours est le programme de dpart, on quitte l'appli
	IF tcProgramme==PROGRAM(1)
		ON SHUTDOWN
		CANCEL								&& Met fin au programme
	ENDIF

	* L'erreur s'est-elle produite dans un programme, ou dans un objet?
	IF AT(".", tcProgramme)==0
		* Le nom du programme en cours ne comportant pas de point, il s'agit d'un prg
		ON ERROR &lcGestErreur
		RETURN TO MASTER					&& retour au programme de dpart
	ELSE
		* Il s'agit bien d'un objet. Si c'est un formulaire, on va le fermer
		IF _SCREEN.ACTIVEFORM.NAME==LEFT(tcProgramme,AT(".", tcProgramme)-1)
			* Abandon de l'ventuelle transaction
			IF TXNLEVEL()>0
				ROLLBACK
			ENDIF

			* Tablerevert des tables
			LOCAL ARRAY laTables(1)

			IF AUSED(laTables) > 0
				FOR I=1 TO ALEN(laTables,1)
					IF CURSORGETPROP('BUFFERING',laTables[i,1]) > 1
						TABLEREVERT(.T.,laTables[i,1])
					ENDIF
				ENDFOR
			ENDIF

			* Destruction de l'objet
			ON SHUTDOWN
			_SCREEN.ACTIVEFORM.RELEASE()
			ON ERROR &lcGestErreur
		ENDIF
	ENDIF

ENDPROC

FUNCTION lse_PathSystem32

	LOCAL lcNom,lnTailleChaine,lnOk,lcReturn

	lnOk=0
	lcNom=SPACE(250)
	lnTailleChaine=250

	DECLARE SHORT GetSystemDirectory IN Kernel32 STRING @lcNom,INTEGER @lnTailleChaine

	lnOk=GetSystemDirectory(@lcNom,@lnTailleChaine)
	lcReturn=IIF(lnOk!=0,lse_chaineSup0(lcNom),"ERREUR FONCTION lse_PathSystem32")
	IIF(gnMessageTrace=1,MESSAGEBOX(lcReturn),"")

	CLEAR DLLS GetSystemDirectory

	RETURN lcReturn

ENDFUNC

FUNCTION lse_CreePostScript(tcGhost,tcImp)

	LOCAL lnId,lcEtat,lcOldImp,lcExec,lcOldAlias,lcAlias,lcReturn

	lnId=FOPEN(pcnomfrx,2)
	IF lnId=-1
		MESSAGEBOX("Le fichier "+ALLTRIM(pcnomfrx)+" est en cours d'utilisation !!!",0+16,"Erreur #2000 !!!")
		RETURN ""
	ENDIF
	=FCLOSE(lnId)

	lcOldAlias=ALIAS()
	lcEtat=JUSTPATH(pcnomfrx)+"\"+JUSTSTEM(pcnomfrx)+".frx"

	lcAlias=JUSTSTEM(pcnomfrx)
	USE &lcEtat. IN 0 ALIAS &lcAlias. SHARED
	SELECT &lcAlias.
	LOCATE FOR &lcAlias..objtype=1
	IF FOUND()
		IF !EMPTY(&lcAlias..TAG)
			SELECT &lcAlias.
			USE
			=lse_OldAlias(lcOldAlias)
			MESSAGEBOX("L'tat "+ALLTRIM(lcEtat)+" est associ  une imprimante !!!",0+16,"Erreur #2001 !!!")
			RETURN ""
		ENDIF
	ENDIF
	SELECT &lcAlias.
	USE
	=lse_OldAlias(lcOldAlias)

	lcEtat=lse_NomCourt(envreptem)+SYS(2015)
	COPY FILE (JUSTPATH(pcnomfrx)+"\"+JUSTSTEM(pcnomfrx)+".frx") TO (lcEtat+".frx")
	COPY FILE (JUSTPATH(pcnomfrx)+"\"+JUSTSTEM(pcnomfrx)+".frt") TO (lcEtat+".frt")

	lcOldImp=SYS(2001,"PRINTER",2)
	SET PRINTER TO NAME (tcImp)
	IF PRINTSTATUS()=.T.
		PRINTJOB
			SELECT QUERY
			GO TOP

			lcExec="REPORT FORM "+lcEtat+".frx TO FILE "+lcEtat+".ps NOCONSOLE"
			&lcExec
		ENDPRINTJOB
		SET PRINTER TO

		* -sDEVICE=<type>		Type de document  gnrer
		* -sOutputFile=<FILE>	Nom du fichier gnr
		* -r<res>  				Resolution en pixels/pouces (ppp)
		* -dBATCH  				Sort aprs la gnration du dernier fichier
		* -dNOPAUSE				Pas de pose aprs la page
		* -q					Quit (n'affiche que quelques messages)
		* -c					token ...
		* -f<type>				Nom du fichier  gnrer
		lcParam="-sDEVICE=pdfwrite -sOutputFile="+lcEtat+".pdf -r600 -dBATCH -dNOPAUSE -q -c 3000000 setvmthreshold .setpdfwrite -f"+lcEtat+".ps"

		=lse_ShellExecute("open",tcGhost,lcParam,"",2)
		IF !FILE(lcEtat+".ps")
			MESSAGEBOX("Le fichier "+lcEtat+".ps n'a pas t trouv!!!",0+16,"Erreur #2002 !!!")
			RETURN ""
		ENDIF

		DO WHILE.T.
			lnId=FOPEN(lcEtat+".pdf",2)
			IF lnId!=-1
				=FCLOSE(lnId)
				EXIT
			ENDIF
		ENDDO
	ELSE
		MESSAGEBOX("Vrifiez l'imprimante "+tcImp+" !!!",0+16,"Erreur #2002 !!!")
		RETURN ""
	ENDIF
	SET PRINTER TO NAME (lcOldImp)

	RETURN lcEtat

ENDFUNC

FUNCTION lse_ImpDef

	LOCAL lcImp,lnTaille

	lnTaille=250
	lcImp=SPACE(lnTaille)

	DECLARE INTEGER GetDefaultPrinter IN winspool.drv STRING @lcImp,INTEGER @lnTaille

	=GetDefaultPrinter(@lcImp,@lnTaille)

	CLEAR DLLS GetDefaultPrinter

	RETURN lse_chaineSup0(lcImp)

ENDFUNC

FUNCTION lse_chaineSup0(tcChaine)

	RETURN SUBSTR(tcChaine,1,AT(CHR(0),tcChaine)-1)

ENDFUNC

FUNCTION lse_OldAlias(tcAlias)

	IF !EMPTY(tcAlias)
		SELECT &tcAlias.
	ENDIF

ENDFUNC

*************************************************************************************

FUNCTION lse_Dte(tdDate,tnType,tcType)

	* tnType 0=  date standard
	*        1=  jour (si tcType="C", alors on retourne une chaine)
	*        2=  libell jour
	*        3=  mois (si tcType="C", alors on retourne une chaine)
	*        4=  libell mois
	*        5=  jour et mois
	*        6=  anne (si tcType="C", alors on retourne une chaine)
	*		 7=  mois et anne
	*		 8=  date avec le libell du jour et du mois
	*			 si tcType="M", la premire lettre est en majuscule
	*       10=  numro de semaine (si tcType="C", alors on retourne une chaine)
	*       11=  premier jour de la semaine	(si tcType="C", alors on retourne une chaine)
	*       12=  dernier jour de la semaine	(si tcType="C", alors on retourne une chaine)
	*		20=  premier jour du mois : passer l'anne "AAAA" dans tdDate et le numro de mois dans tcType
	*			 Janvier : tcType="1"
	*			 ex : lse_Dte("2003",20,"2") donne 01-02-2003
	*			 Remarque si tcType="Cx" o x est le numro de mois, alors on retourne une chaine
	*			 ex : lse_Dte("2003",20,"C2") donne "01-02-2003"
	*		21=  dernier jour du mois : passer l'anne "AAAA" dans tdDate et le numro de mois dans tcType
	*			 Janvier : tcType="1"
	*			 ex : lse_Dte("2003",21,"2") donne 28-02-2003
	*				  lse_Dte("2000",21,"2") donne 29-02-2000
	*			 Remarque si tcType="Cx" o x est le numro de mois, alors on retourne une chaine
	*			 ex : lse_Dte("2003",21,"C2") donne "28-02-2003"
	*				  lse_Dte("2000",21,"C2") donne "29-02-2000"
	*		30=  numro de jour dans le mois

	LOCAL ldDate,lnDate,lcChaine,lnAnnee,lnMois,lnJour,lnJ

	tnType=IIF(UPPER(VARTYPE(tnType))=="L",0,tnType)
	tcType=IIF(UPPER(VARTYPE(tcType))=="L","",tcType)
	tdDate=IIF(UPPER(VARTYPE(tdDate))=="L",DATE(),tdDate)
	IF tnType==20
		tdDate=CTOD("01-01-"+tdDate)
		lcChaine=""
		IF LEFT(tcType,1)=="C"
			lcChaine="C"
			lnDate=VAL(SUBSTR(tcType,2))-1
		ELSE
			lnDate=VAL(tcType)-1
		ENDIF
	ENDIF
	IF tnType==21
		tdDate=CTOD("31-01-"+tdDate)
		lcChaine=""
		IF LEFT(tcType,1)=="C"
			lcChaine="C"
			lnDate=VAL(SUBSTR(tcType,2))-1
		ELSE
			lnDate=VAL(tcType)-1
		ENDIF
	ENDIF

	IF EMPTY(tdDate)
		ldDate=DATE()
	ELSE
		IF UPPER(VARTYPE(tdDate))=="C"
			ldDate=CTOD(tdDate)
		ELSE
			ldDate=tdDate
		ENDIF
	ENDIF

	DO CASE
		CASE tnType==1
			IF tcType=="C"
				RETURN lse_Ntoc(DAY(ldDate))
			ELSE
				RETURN DAY(ldDate)
			ENDIF

		CASE tnType==2
			IF tcType=="M"
				RETURN PROPER(CDOW(ldDate))
			ELSE
				RETURN CDOW(ldDate)
			ENDIF

		CASE tnType==3
			IF tcType=="C"
				RETURN lse_Ntoc(MONTH(ldDate))
			ELSE
				RETURN MONTH(ldDate)
			ENDIF

		CASE tnType==4
			RETURN CMONTH(ldDate)

		CASE tnType==5
			RETURN lse_Ntoc(DAY(ldDate))+"-"+lse_Ntoc(MONTH(ldDate))

		CASE tnType==6
			IF tcType=="C"
				RETURN lse_Ntoc(YEAR(ldDate))
			ELSE
				RETURN YEAR(ldDate)
			ENDIF

		CASE tnType==7
			RETURN lse_Ntoc(MONTH(ldDate))+"-"+lse_Ntoc(YEAR(ldDate))

		CASE tnType==8
			IF tcType=="M"
				RETURN PROPER(CDOW(ldDate)+" "+DMY(ldDate))
			ELSE
				RETURN CDOW(ldDate)+" "+DMY(ldDate)
			ENDIF

		CASE tnType==10
			IF tcType=="C"
				RETURN lse_Ntoc(WEEK(ldDate,2,2))
			ELSE
				RETURN WEEK(ldDate,2,2)
			ENDIF

		CASE tnType==11
			lnDate=DOW(ldDate,2)-1		&& numro du jour dans la semaine
			IF lnDate==0
				IF tcType=="C"
					RETURN DTOC(ldDate)
				ELSE
					RETURN ldDate
				ENDIF
			ELSE
				lnJour=DAY(ldDate)
				lnMois=MONTH(ldDate)
				lnAnnee=YEAR(ldDate)
				IF lnJour-lnDate<1
					lnDate=lnJour-lnDate
					lnMois=lnMois-1
					IF lnMois<1
						lnMois=12
						lnAnnee=lnAnnee-1
					ENDIF
					ldDate=CTOD("31-01-"+lse_Ntoc(lnAnnee))
					ldDate=GOMONTH(ldDate,lnMois-1)

					lnJour=DAY(ldDate)+lnDate
					lnMois=MONTH(ldDate)
					lnAnnee=YEAR(ldDate)
				ELSE
					lnJour=lnJour-lnDate
				ENDIF
				IF tcType=="C"
					RETURN DTOC(lse_Dte2(lnAnnee,lnMois,lnJour))
				ELSE
					RETURN lse_Dte2(lnAnnee,lnMois,lnJour)
				ENDIF
			ENDIF

		CASE tnType==12
			lnDate=6-(DOW(ldDate,2)-1)		&& numro du jour dans la semaine
			IF lnDate==0
				IF tcType=="C"
					RETURN DTOC(ldDate)
				ELSE
					RETURN ldDate
				ENDIF
			ELSE
				lnJour=DAY(ldDate)+lnDate
				lnMois=MONTH(ldDate)
				lnAnnee=YEAR(ldDate)
				lnJ=EVALUATE(LEFT(DTOC(GOMONTH(CTOD("31-01-"+lse_Ntoc(lnAnnee)),lnMois-1)),2))
				IF lnJ<lnJour
					lnJour=lnJour-lnJ
					lnMois=lnMois+1
					IF lnMois>12
						lnMois=1
						lnAnnee=lnAnnee+1
					ENDIF
				ENDIF
				IF tcType=="C"
					RETURN DTOC(lse_Dte2(lnAnnee,lnMois,lnJour))
				ELSE
					RETURN lse_Dte2(lnAnnee,lnMois,lnJour)
				ENDIF
			ENDIF

		CASE tnType==20
			IF lcChaine=="C"
				RETURN DTOC(GOMONTH(tdDate,lnDate))
			ELSE
				RETURN GOMONTH(tdDate,lnDate)
			ENDIF

		CASE tnType==21
			IF lcChaine=="C"
				RETURN DTOC(GOMONTH(tdDate,lnDate))
			ELSE
				RETURN GOMONTH(tdDate,lnDate)
			ENDIF

			IF tnType==30
				IF lcChaine=="C"
					RETURN lse_Ntoc(tdDate-CTOD("31/12/"+lse_Ntoc(INT(VAL(RIGHT(DTOC(tdDate),4)))-1)))
				ELSE
					RETURN tdDate-CTOD("31/12/"+lse_Ntoc(INT(VAL(RIGHT(DTOC(tdDate),4)))-1))
				ENDIF
			ENDIF

		OTHERWISE
			IF tnType!=0
				MESSAGEBOX("Erreur fonction 'lse_Dte' : type inexistant"+CHR(13)+"Date : "+DTOC(tdDate)+CHR(13)+"Type : "+lse_Ntoc(tnType)+CHR(13)+"Opt  : "+tcType)
				RETURN ldDate
			ELSE
				IF tcType=="C"
					RETURN DTOC(ldDate)
				ELSE
					RETURN ldDate
				ENDIF
			ENDIF
	ENDCASE

ENDFUNC

FUNCTION lse_Dte2(tnAnnee,tnMois,tnJour)

	tnAnnee=IIF(UPPER(VARTYPE(tnAnnee))=="L",VAL(DTOC(DATE())),tnAnnee)
	tnMois=IIF(UPPER(VARTYPE(tnMois))=="L",1,tnMois)
	tnJour=IIF(UPPER(VARTYPE(tnJour))=="L",1,tnJour)

	RETURN DATE(tnAnnee,tnMois,tnJour)

ENDFUNC

*************************************************************************************

FUNCTION lse_Tempo

	LOCAL lnSec

	lnSec=SECONDS()
	DO WHILE lnSec+30>SECONDS()
	ENDDO

ENDFUNC

PROCEDURE lse_Temporisation(tnTempo)

	LOCAL lnI

	FOR lnI=1 TO IIF(tnTempo=0,30000000,tnTempo)
	ENDFOR

ENDPROC

*************************************************************************************

FUNCTION lse_MemoVide(tmMemo)

	LOCAL lnI,lcLig,lcLect,lnMax

	IF EMPTY(tmMemo) OR ISNULL(tmMemo)
		RETURN ""
	ENDIF

	lnMax=MEMLINES(tmMemo)
	DO WHILE .T.
		lcLect=MLINE(tmMemo,lnMax)
		IF (LEN(lcLect)=2 AND lcLect=CHR(13)+CHR(10)) OR (lcLect="")
			lnMax=lnMax-1
			LOOP
		ELSE
			EXIT
		ENDIF
	ENDDO

	lcLig=""
	FOR lnI=1 TO lnMax
		lcLect=ALLTRIM(MLINE(tmMemo,lnI))
		lcLig=lcLig+IIF(lnI>1,CHR(13)+CHR(10),"")+lcLect
	NEXT

	RETURN ALLTRIM(lcLig)

ENDFUNC

*************************************************************************************

FUNCTION lse_CreateLiv(tcCdeId)

	* Permet de savoir si la variable cceqtrliv est mise  jour ou non
	* IIF(llCreation=.T.,cceqtrliv-lceqtucv,cceqtrliv)

	* La proprit NAME du formulaire change si on l'appelle plusieurs fois.
	* La proprit lRepriseCcg n'existe que dans l'cran de livraison des BC

	* On va chercher parmis tous les crans ouverts, ceux qui ont cette proprit
	* Une fois trouv, on va chercher l'cran qui a le mme numro de BC
	* Une fois trouv, on va obtenir la valeur de la proprit lRepriseCcg
	* Si lRepriseCcg=.T. et lInsert=.T., on est en cration.

	LOCAL lnI,llCreation

	llCreation=.F.
	FOR lnI=1 TO _SCREEN.FORMCOUNT
		IF PEMSTATUS(_SCREEN.FORMS(lnI),"lRepriseCcg",5)
			IF _SCREEN.FORMS(lnI).cCcgCode=tcCdeId
				IF _SCREEN.FORMS(lnI).lRepriseCcg=.T. AND _SCREEN.FORMS(lnI).lInsert=.T.
					llCreation=.T.
				ENDIF
				EXIT
			ENDIF
		ENDIF
	ENDFOR

	RETURN llCreation

ENDFUNC

*************************************************************************************

FUNCTION lse_EtatTitre

	RETURN ALLTRIM(IIF(lserech('eta','etafic="'+LEFT(goProgram.cEditCode,3)+'" AND etacode="'+RIGHT(goProgram.cEditCode,3)+'"','etadesig'),ALLTRIM(LEFT(eta.etadesig,IIF(AT("(",eta.etadesig)>0,AT("(",eta.etadesig)-1,LEN(eta.etadesig)))),'?'))

ENDFUNC

*************************************************************************************

FUNCTION lse_FsoFichier(tcFic,tcAction)

	LOCAL loFile,loFichier,lcRet

	tcFic=ALLTRIM(UPPER(tcFic))
	tcAction=ALLTRIM(UPPER(tcAction))
	IF tcAction<>"TEMP" AND EMPTY(tcFic)
		MESSAGEBOX("Fonction : lse_FsoFichier"+CHR(13)+CHR(13)+"Spcifier un nom de fichier !!!")
		RETURN ""
	ENDIF

	loFile=CREATEOBJECT("Scripting.FileSystemObject")
	loFichier=loFile.GETFILE(tcFic)
	lcRet=""
	DO CASE
		CASE tcAction="TEMP"
			lcRet="_"+loFile.GetTempName()
		CASE tcAction="SIZE"
			lcRet=loFichier.SIZE
		CASE tcAction="DATECREAT"
			lcRet=LEFT(TTOC(loFichier.DateCreated),10)
		CASE tcAction="HEURECREAT"
			lcRet=RIGHT(TTOC(loFichier.DateCreated),8)
		CASE tcAction="NOMCOURT"
			lcRet=loFichier.ShortName
		CASE tcAction="CHEMINCOURT"
			lcRet=loFichier.ShortPath
		CASE tcAction="ATTRIBUT"
			lcRet=loFichier.ATTRIBUTES
		CASE tcAction="TYPE"
			lcRet=loFichier.TYPE
	ENDCASE
	RELEASE loFile,loFichier

	RETURN lcRet

ENDFUNC

*************************************************************************************

FUNCTION lse_NomCourt(tcNom)

	LOCAL lcRepLong,lcRepCourt,lnTailleChaine,lnOk,lcReturn

	lcRepLong=ALLTRIM(tcNom)
	lcRepCourt=SPACE(255)
	lnTailleChaine=255

	DECLARE SHORT GetShortPathName IN Kernel32 STRING @lcRepLong,STRING @lcRepCourt,INTEGER @lnTailleChaine

	lnOk=GetShortPathName(@lcRepLong,@lcRepCourt,@lnTailleChaine)
	lcReturn=IIF(lnOk!=0,lse_chaineSup0(lcRepCourt),"")

	CLEAR DLLS GetShortPathName

	RETURN lcReturn

ENDFUNC

*************************************************************************************

PROCEDURE lse_Pdf(tcFic)

	PUBLIC gcPrg,gcExec,gnCopie,gcEmailCli,gcEmailRep,gcCliNom,gnNum

	gcSessionID=_SCREEN.ACTIVEFORM.DATASESSIONID

	SELECT QUERY
	GO TOP
	gnNum=IIF(TYPE("QUERY."+tcFic+"cgnum")="N",QUERY.dcgnum,"")
	gcCliNom=ALLTRIM(IIF(TYPE("QUERY."+tcFic+"cgemail")="C",QUERY.dcgclinom,""))
	gcEmailCli=ALLTRIM(IIF(TYPE("QUERY."+tcFic+"cgemail")="C",QUERY.dcgemail,""))
	gcEmailRep=ALLTRIM(IIF(TYPE("QUERY."+tcFic+"cgvrpcode")="C",QUERY.dcgvrpcode,""))
	gcEmailRep=IIF(lserech("vrp","vrpcode="+fmtexprchar(gcEmailRep),"vrpemail"),vrp.vrpemail,"")

	gcPrg=envrepeta+"_lse"
	gcExec=IIF(!FILE(gcPrg+".fxp"),"COMPILE "+gcPrg+".prg","")
	&gcExec

	gnCopie=goProgram.nNbDoc
	goProgram.nNbDoc=1
	DO FORMS (ADDBS(envrepeta)+"_PostScript.scx")
	goProgram.nNbDoc=gnCopie


	SELECT QUERY.* FROM QUERY WHERE 1=2 INTO CURSOR QUERY NOFILTER

	RELEASE gcPrg,gcExec,gnCopie,gcEmailCli,gcEmailRep,gcCliNom

ENDPROC

*************************************************************************************

FUNCTION lse_EtatTitre

	RETURN ALLTRIM(IIF(lserech('eta','etafic="'+LEFT(goProgram.cEditCode,3)+'" AND etacode="'+RIGHT(goProgram.cEditCode,3)+'"','etadesig'),ALLTRIM(LEFT(eta.etadesig,IIF(AT("(",eta.etadesig)>0,AT("(",eta.etadesig)-1,LEN(eta.etadesig)))),'?'))

ENDFUNC

*************************************************************************************

FUNCTION _LseExtractSelect(tcParam)

	LOCAL lcReturn

	lcReturn=LOWER(tcParam)
	RETURN ALLTRIM(SUBSTR(lcReturn,7,AT("from",lcReturn)-7))

ENDFUNC

FUNCTION _LseExtractFrom(tcParam)

	LOCAL lcReturn

	lcReturn=tcParam
	IF AT("from",lcReturn)>0
		lcReturn=ALLTRIM(SUBSTR(lcReturn,AT("from",lcReturn)+4,250))
		IF AT("where",lcReturn)>0
			lcReturn=ALLTRIM(LEFT(lcReturn,AT("where",lcReturn)-1))
		ELSE
			IF AT("order by",lcReturn)>0
				lcReturn=ALLTRIM(LEFT(lcReturn,AT("order by",lcReturn)-1))
			ELSE
				IF AT("group by",lcReturn)>0
					lcReturn=ALLTRIM(LEFT(lcReturn,AT("group by",lcReturn)-1))
				ELSE
					IF AT("into",lcReturn)>0
						lcReturn=ALLTRIM(LEFT(lcReturn,AT("into",lcReturn)-1))
					ENDIF
				ENDIF
			ENDIF
		ENDIF
	ELSE
		lcReturn=""
	ENDIF
	RETURN lcReturn

ENDFUNC

FUNCTION _LseExtractWhere(tcParam)

	LOCAL lcReturn

	lcReturn=tcParam
	IF AT("where",lcReturn)>0
		lcReturn=ALLTRIM(SUBSTR(lcReturn,AT("where",lcReturn)+5,250))
		IF AT("order by",lcReturn)>0
			lcReturn=ALLTRIM(LEFT(lcReturn,AT("order by",lcReturn)-1))
		ELSE
			IF AT("group by",lcReturn)>0
				lcReturn=ALLTRIM(LEFT(lcReturn,AT("group by",lcReturn)-1))
			ELSE
				IF AT("into",lcReturn)>0
					lcReturn=ALLTRIM(LEFT(lcReturn,AT("into",lcReturn)-1))
				ENDIF
			ENDIF
		ENDIF
	ELSE
		lcReturn=""
	ENDIF
	RETURN lcReturn

ENDFUNC

FUNCTION _LseExtractOrderBy(tcParam)

	LOCAL lcReturn

	lcReturn=tcParam
	IF AT("order by",lcReturn)>0
		lcReturn=ALLTRIM(SUBSTR(lcReturn,AT("order by",lcReturn)+8,250))
		IF AT("group by",lcReturn)>0
			lcReturn=ALLTRIM(LEFT(lcReturn,AT("group by",lcReturn)-1))
		ELSE
			IF AT("into",lcReturn)>0
				lcReturn=ALLTRIM(LEFT(lcReturn,AT("into",lcReturn)-1))
			ENDIF
		ENDIF
	ELSE
		lcReturn=""
	ENDIF
	RETURN lcReturn

ENDFUNC

FUNCTION _LseExtractGroupBy(tcParam)

	LOCAL lcReturn

	lcReturn=tcParam
	IF AT("group by",lcReturn)>0
		lcReturn=ALLTRIM(SUBSTR(lcReturn,AT("group by",lcReturn)+9,250))
		IF AT("into",lcReturn)>0
			lcReturn=ALLTRIM(LEFT(lcReturn,AT("into",lcReturn)-1))
		ENDIF
	ELSE
		lcReturn=""
	ENDIF
	RETURN lcReturn

ENDFUNC

FUNCTION _LseExtractInto(tcParam)

	LOCAL lcReturn

	lcReturn=tcParam
	IF AT("into",lcReturn)>0
		lcReturn=ALLTRIM(SUBSTR(lcReturn,AT("into",lcReturn)+5,250))
	ELSE
		lcReturn=""
	ENDIF
	RETURN lcReturn

ENDFUNC

FUNCTION _lseSuppSousChaine(tcChaine,tcRech)

	LOCAL lnPos,lnPos2,lcTexte,lcRech

	tcChaine=ALLTRIM(tcChaine)
	IF LEN(tcChaine)=0
		RETURN tcChaine
	ENDIF

	tcRech=ALLTRIM(tcRech)
	IF LEN(tcRech)=0
		RETURN tcChaine
	ENDIF

	lnPos=AT(tcRech,tcChaine)
	IF lnPos=0
		RETURN tcChaine
	ENDIF
	lnPos2=LEN(tcRech)
	IF lnPos2=0
		RETURN tcChaine
	ENDIF

	RETURN SUBSTR(tcChaine,1,lnPos-1)+RIGHT(tcChaine,LEN(tcChaine)-lnPos-lnPos2+1)

ENDFUNC

FUNCTION _LseReq(tcParam)

	RETURN "SELECT"+CHR(9)+CHR(9)+_LseExtractSelect(tcParam)+CHR(13) ;
		+"FROM"+CHR(9)+CHR(9)+_LseExtractFrom(tcParam)+CHR(13) ;
		+"WHERE"+CHR(9)+CHR(9)+_LseExtractWhere(tcParam)+CHR(13) ;
		+"ORDER BY"+CHR(9)+_LseExtractOrderBy(tcParam)+CHR(13) ;
		+"GROUP BY"+CHR(9)+_LseExtractGroupBy(tcParam)+CHR(13) ;
		+"INTO"+CHR(9)+CHR(9)+_LseExtractInto(tcParam)

ENDFUNC

PROC _LsePrc

	LOCAL lcTalk,lcAlias,lcTable,lcSelect,lcFrom
	LOCAL lnNiv,lnFiches,lcSql,lcAdd,lcIdent,lnIdent,lcCode,oPrc

	lcTalk=SYS(2001,"TALK")
	SET TALK OFF

	=ficsel("prc")
	=ficsel("pro")
	lcAlias=_LseNomTableTemp()
	lcSelect=_LseExtractSelect(goProgram.cEditSql)
	lcWhere=STRTRAN(_LseExtractWhere(goProgram.cEditSql)," ","")

	SELECT QUERY
	COUNT TO lnFiches

	IF AT("procode='",lcWhere)==0
		SET TALK &gcTalk
		lcSql="SELECT QUERY.* FROM QUERY WHERE 1=2 INTO CURSOR QUERY NOFILTER"
		&lcSql
		SELECT QUERY
		MESSAGEBOX("Slectionnez un seul article")
		RETURN
	ENDIF

	IF AT("prcident",lcSelect)>0 AND AT("prcproid",lcSelect)==0
		SET TALK &gcTalk
		lcSql="SELECT QUERY.* FROM QUERY WHERE 1=2 INTO CURSOR QUERY NOFILTER"
		&lcSql
		SELECT QUERY
		MESSAGEBOX("Les variables 'prcident' et 'prcproid' doivent tre dclares dans l'dition")
		RETURN
	ENDIF
	IF lnFiches==0
		SET TALK &gcTalk
		RETURN
	ENDIF

	lcAdd=""
	lcAdd=lcAdd+IIF(AT("prccode",lcSelect)==0,",prc.prccode","")
	lcAdd=lcAdd+IIF(AT("prcdesig",lcSelect)==0,",prc.prcdesig","")
	lcAdd=lcAdd+IIF(AT("prctype",lcSelect)==0,",prc.prctype","")
	lcAdd=lcAdd+IIF(AT("prcqt",lcSelect)==0,",prc.prcqt","")
	lcAdd=lcAdd+IIF(AT("prcproid",lcSelect)==0,",prc.prcproid","")

	SELECT QUERY
	lcSql=IIF(!EMPTY(lcAdd),"SELECT "+lcSelect+lcAdd+" FROM QUERY LEFT JOIN prc ON QUERY.prcident=prc.prcident INTO CURSOR QUERY NOFILTER","")
	&lcSql
	lcSql="SELECT QUERY.*,prcident AS niv_prc FROM QUERY INTO CURSOR QUERY NOFILTER"
	&lcSql

	SELECT QUERY
	lcSelect=lcSelect+lcAdd

	lcTable=ADDBS(envreptem)+lcAlias
	lcSql="SELECT QUERY.* FROM QUERY INTO TABLE "+lcTable+".dbf"
	&lcSql

	SELECT &lcAlias.
	USE

	lcSql="USE "+lcTable+".dbf IN 0 ALIAS "+lcAlias+" EXCLUSIVE"
	&lcSql

	SELECT &lcAlias.
	ZAP

	SELECT QUERY
	GO TOP

	lcCode=QUERY.prcprocode
	lnNiv=1
	lnIdent=LEN(QUERY.prcident)
	SCAN
		lcIdent=QUERY.prcprcid
		SCATTER NAME oPrc MEMO
		SELECT &lcAlias.
		APPEND BLANK
		GATHER NAME oPrc MEMO
		REPLACE &lcAlias..niv_prc WITH RIGHT(REPLICATE("0",lnIdent)+ALLTRIM(STR(lnNiv)),lnIdent) ,;
			&lcAlias..prcprocode WITH lcCode

		IF QUERY.prctype<>"N"
			=_LsePrcCompo(lcIdent,lcCode,lnNiv,lcSelect,lcAlias)
		ENDIF
		SELECT QUERY
	ENDSCAN

	lcSql="SELECT "+lcAlias+".* FROM "+lcAlias+" INTO CURSOR QUERY NOFILTER"
	&lcSql
	SELECT &lcAlias.
	USE
	=_LseDeleteTable(lcTable+".dbf")

	SET TALK &gcTalk
	SELECT QUERY

ENDPROC

FUNCTION _LsePrcCompo(tcIdent,tcCode,tnNiv,tcSelect,tcAlias)

	LOCAL lcSql,lcAlias,lcTable,lnNiv,lcIdent,lnIdent,oPrc

	lcAlias=_LseNomTableTemp()
	lcTable=ADDBS(envreptem)+lcAlias

	lcIdent=tcIdent

	lcSql="SELECT "+tcSelect+",prcident AS niv_prc FROM prc LEFT JOIN pro ON prcprocode=procode WHERE (prcproid="+CHR(34)+lcIdent+CHR(34)+") ORDER BY prcnumsais INTO TABLE "+lcTable+".dbf"
	&lcSql
	SELECT &lcAlias.
	USE


	lcSql="USE "+lcTable+".dbf IN 0 ALIAS "+lcAlias+" EXCLUSIVE"
	&lcSql

	SELECT &lcAlias.
	GO TOP

	tnNiv=tnNiv+1
	lnNiv=tnNiv
	lnIdent=LEN(&lcAlias..prcident)
	SCAN
		lcIdent=&lcAlias..prcprcid
		SCATTER NAME oPrc MEMO
		SELECT &tcAlias.
		APPEND BLANK
		GATHER NAME oPrc MEMO
		REPLACE &tcAlias..niv_prc WITH RIGHT(REPLICATE("0",lnIdent)+ALLTRIM(STR(lnNiv)),lnIdent) ,;
			&tcAlias..prcprocode WITH tcCode

		IF &lcAlias..prctype<>"N"
			=_LsePrcCompo(lcIdent,tcCode,lnNiv,tcSelect,tcAlias)
		ENDIF
		SELECT &lcAlias.
	ENDSCAN

	SELECT &lcAlias.
	USE
	=_LseDeleteTable(lcTable+".dbf")

ENDFUNC

*************************************************************************************

FUNCTION lse_DecaleDateDebut

	PUBLIC gcFerme1,gcFerme2,gaFerie[1],gcFichierIni,gnDernier,gnI,gcLect,gnMax

	gcFichierIni=envrepeta+"ferie.ini"

	STORE "" TO gcFerme1,gcFerme2,gaFerie
	gnMax=0
	IF !EMPTY(gcFichierIni)
		gcFerme1=LOWER(ALLTRIM(lse_LitIni(gcFichierIni,"FERME","FERME1")))
		gcFerme2=LOWER(ALLTRIM(lse_LitIni(gcFichierIni,"FERME","FERME2")))
		gnDernier=INT(VAL(ALLTRIM(lse_LitIni(gcFichierIni,"FERIE-DERNIER","DERNIER"))))
		IF gnDernier>0
			FOR gnI=1 TO gnDernier
				gcLect=LOWER(ALLTRIM(lse_LitIni(gcFichierIni,"FERIE","FERIE"+RIGHT("000"+ALLTRIM(STR(gnI)),3))))
				IF !EMPTY(gcLect)
					gcLect=STRTRAN(gcLect,"-","/")
					gnMax=gnMax+1
					DIMENSION gaFerie[gnMax]
					gaFerie[gnMax]=gcLect
				ENDIF
			ENDFOR
		ENDIF
	ENDIF
	IF EMPTY(gcFerme1) AND EMPTY(gcFerme2)
		gcFerme1="samedi"
		gcFerme2="dimanche"
	ENDIF

ENDFUNC

FUNCTION lse_DecaleDateFin

	RELEASE gcFerme1,gcFerme2,gaFerie[1],gcFichierIni,gnDernier,gnI,gcLect,gnMax

ENDFUNC

FUNCTION lse_DecaleDate(tdDate,tnDecale,tcFerme1,tcFerme2,taFerie,tnMax)

	EXTERNAL ARRAY taFerie

	* tdDate	Date recherche
	* tnDecale  Dcalage -3 jour, +3 jours, 0 jour
	* tcFerme1	1er jour fri (samedi), (dimanche)
	* tcFerme2	2me jour fri (dimanche), (lundi)
	* taFerie	tableau contenant des jours fris (de 0  999)

	* DATES FIXES
	* 01-01-xxxx - Jour de l'an
	* 01-05-xxxx - Fte du Travail
	* 08-05-xxxx - Victoire
	* 14-07-xxxx - Fte nationale
	* 15-08-xxxx - Assomption
	* 01-11-xxxx - Toussaint
	* 11-11-xxxx - Armistice
	* 25-12-xxxx - Nol

	* DATE VARIABLES
	* Lundi de pacques, l'ascencion et le lundi de pentecte

	LOCAL lcPacques,lcLundiPacques,lcAscencion,lcPentecote,lnSens
	LOCAL lcAn,lcPremierMai,lcHuitMai,lcQuatorzeJuillet,lcQuinzeAout,lcPremierNovembre,lcOnzeNovembre,lcNoel
	LOCAL lcDate,lcJour,lnI,lnMax,laFerie[20],llDecale

	lnSens=IIF(SIGN(tnDecale)=-1,-1,1)

	lcDate=DTOC(tdDate)
	IF INT(VAL(RIGHT(lcDate,4)))=0 AND INT(VAL(SUBSTR(lcDate,4,2)))=0 AND INT(VAL(LEFT(lcDate,2)))=0
		RETURN CTOD("")
	ENDIF
	DO WHILE .T.
		lcDate=lse_DecaleDate2(lcDate,tnDecale)

		lcAn="01/01/"+RIGHT(lcDate,4)
		lcPremierMai="01/05/"+RIGHT(lcDate,4)
		lcHuitMai="08/05/"+RIGHT(lcDate,4)
		lcQuatorzeJuillet="14/07/"+RIGHT(lcDate,4)
		lcQuinzeAout="15/08/"+RIGHT(lcDate,4)
		lcPremierNovembre="01/11/"+RIGHT(lcDate,4)
		lcOnzeNovembre="11/11/"+RIGHT(lcDate,4)
		lcNoel="25/12/"+RIGHT(lcDate,4)

		lcPacques=lse_CalculPaques(YEAR(CTOD(lcDate)))
		lcLundiPacques=lse_DateLundiPacques(lcPacques)
		lcAscencion=lse_DateAscencion(lcPacques)
		lcPentecote=lse_DatePentecote(lcPacques)

		lcJour=LOWER(ALLTRIM(CDOW(CTOD(lcDate))))
		IF lnSens=-1
			IF !EMPTY(tcFerme2)
				IF lcJour==tcFerme2
					tnDecale=-1
					LOOP
				ENDIF
			ENDIF
			IF !EMPTY(tcFerme1)
				IF lcJour==tcFerme1
					tnDecale=-1
					LOOP
				ENDIF
			ENDIF
			IF lcDate==lcAn OR lcDate=lcPremierMai OR lcDate=lcHuitMai OR lcDate=lcQuatorzeJuillet OR lcDate=lcQuinzeAout OR lcDate=lcPremierNovembre OR lcDate=lcOnzeNovembre OR lcDate=lcNoel
				tnDecale=-1
				LOOP
			ENDIF
			IF lcDate==lcLundiPacques
				tnDecale=-2
				LOOP
			ENDIF
			IF lcDate==lcPacques
				tnDecale=-1
				LOOP
			ENDIF
			IF lcDate==lcAscencion OR lcDate==lcPentecote
				tnDecale=-1
				LOOP
			ENDIF
		ELSE
			IF !EMPTY(tcFerme1)
				IF lcJour==tcFerme1
					tnDecale=+1
					LOOP
				ENDIF
			ENDIF
			IF !EMPTY(tcFerme2)
				IF lcJour==tcFerme2
					tnDecale=1
					LOOP
				ENDIF
			ENDIF
			IF lcDate==lcAn OR lcDate=lcPremierMai OR lcDate=lcHuitMai OR lcDate=lcQuatorzeJuillet OR lcDate=lcQuinzeAout OR lcDate=lcPremierNovembre OR lcDate=lcOnzeNovembre OR lcDate=lcNoel
				tnDecale=1
				LOOP
			ENDIF
			IF lcDate==lcPacques
				tnDecale=2
				LOOP
			ENDIF
			IF lcDate==lcLundiPacques
				tnDecale=1
				LOOP
			ENDIF
			IF lcDate==lcAscencion OR lcDate==lcPentecote
				tnDecale=1
				LOOP
			ENDIF
		ENDIF
		* Traitement des jours feris issus du fichier ini
		IF tnMax>0
			llDecale=.F.
			FOR lnI=1 TO tnMax
				IF lcDate=taFerie[lnI]
					llDecale=.T.
					EXIT
				ENDIF
			ENDFOR
			IF llDecale=.T.
				tnDecale=lnSens
				LOOP
			ENDIF
		ENDIF
		EXIT
	ENDDO

	RETURN CTOD(lcDate)

ENDFUNC

FUNCTION lse_DecaleDate2(tcDate,tnDecale)

	LOCAL lnAn,lnMois,lnJour,lnMax[12]

	lnAn=INT(VAL(RIGHT(tcDate,4)))
	lnMois=INT(VAL(SUBSTR(tcDate,4,2)))
	lnJour=INT(VAL(LEFT(tcDate,2)))

	lnMax[1]=31
	lnMax[2]=28+IIF(INT(lnAn/4)=(lnAn/4),1,0)-IIF(INT(lnAn/400)=(lnAn/400),1,0)
	lnMax[3]=31
	lnMax[4]=30
	lnMax[5]=31
	lnMax[6]=30
	lnMax[7]=31
	lnMax[8]=31
	lnMax[9]=30
	lnMax[10]=31
	lnMax[11]=30
	lnMax[12]=31

	IF SIGN(tnDecale)=-1
		lnJour=lnJour+tnDecale
		IF lnJour<1
			lnMois=lnMois-1
			IF lnMois<1
				lnAn=lnAn-1
				lnMois=12
				lnJour=31+lnJour
			ELSE
				lnJour=IIF(lnMois<>2,IIF(INLIST(lnMois,1,3,5,7,8,10,12),31,30),lnMax[2])+lnJour
			ENDIF
		ENDIF
	ELSE
		lnJour=lnJour+tnDecale
		IF lnJour>lnMax[lnMois]
			lnJour=1
			lnMois=lnMois+1
			IF lnMois>2
				lnAn=lnAn+1
				lnMois=1
			ENDIF
		ENDIF
	ENDIF

	RETURN lse_FormateDate(lnJour,lnMois,lnAn)

ENDFUNC

FUNCTION lse_DateLundiPacques(tcDate)

	* Lundi de pacques (avril)	Paques+1

	RETURN RIGHT("00"+ALLTRIM(STR(INT(VAL(LEFT(tcDate,2)))+1,2)),2)+RIGHT(tcDate,LEN(tcDate)-2)

ENDFUNC

FUNCTION lse_DateAscencion(tcDate)

	* Ascencion =Paques+39

	LOCAL lnAn,lnMois,lnJour,lnDecale,lnMax[12]

	lnAn=VAL(RIGHT(tcDate,4))
	lnMois=VAL(SUBSTR(tcDate,4,2))
	lnJour=VAL(LEFT(tcDate,2))
	lnDecale=39

	lnMax[1]=31
	lnMax[2]=28+IIF(INT(lnAn/4)=(lnAn/4),1,0)-IIF(INT(lnAn/400)=(lnAn/400),1,0)
	lnMax[3]=31
	lnMax[4]=30
	lnMax[5]=31
	lnMax[6]=30
	lnMax[7]=31
	lnMax[8]=31
	lnMax[9]=30
	lnMax[10]=31
	lnMax[11]=30
	lnMax[12]=31

	lnDecale=lnDecale-(lnMax[lnMois]-lnJour)
	lnMois=lnMois+1
	IF lnDecale>lnMax[lnMois]
		lnMois=lnMois+1
		lnDecale=lnDecale-lnMax[lnMois]
	ENDIF
	lnJour=lnDecale

	RETURN lse_FormateDate(lnJour,lnMois,lnAn)

ENDFUNC

FUNCTION lse_DatePentecote(tcDate)

	* Pentecte =Paques+49

	LOCAL lnAn,lnMois,lnJour,lnDecale,lnMax[12]

	lnAn=INT(VAL(RIGHT(tcDate,4)))
	lnMois=INT(VAL(SUBSTR(tcDate,4,2)))
	lnJour=INT(VAL(LEFT(tcDate,2)))
	lnDecale=49

	lnMax[1]=31
	lnMax[2]=28+IIF(INT(lnAn/4)=(lnAn/4),1,0)-IIF(INT(lnAn/400)=(lnAn/400),1,0)
	lnMax[3]=31
	lnMax[4]=30
	lnMax[5]=31
	lnMax[6]=30
	lnMax[7]=31
	lnMax[8]=31
	lnMax[9]=30
	lnMax[10]=31
	lnMax[11]=30
	lnMax[12]=31

	lnDecale=lnDecale-(lnMax[lnMois]-lnJour)
	lnMois=lnMois+1
	IF lnDecale>lnMax[lnMois]
		lnMois=lnMois+1
		lnDecale=lnDecale-lnMax[lnMois]
	ENDIF
	lnJour=lnDecale

	RETURN lse_FormateDate(lnJour,lnMois,lnAn)

ENDFUNC

FUNCTION lse_FormateDate(tnJour,tnMois,tnAn)

	RETURN RIGHT("00"+ALLTRIM(STR(tnJour)),2)+"/"+RIGHT("00"+ALLTRIM(STR(tnMois)),2)+"/"+ALLTRIM(STR(tnAn,4))

ENDFUNC

FUNCTION lse_CalculPaques(tnAn)

	LOCAL lnA,lnB,lnC,lnE,lnF,lnG,lnH,lnI,lnJ,lnK,lnM,lnN,lnP,lnR

	* Calcul du jour correspondant au dimanche de Paques
	lnA=MOD(tnAn,19)
	lnB=INT(tnAn/100)
	lnC=MOD(tnAn,100)
	lnP=INT(lnB/4)
	lnE=MOD(lnB,4)
	lnF=INT((lnB+8)/25)
	lnG=INT((lnB-lnF+1)/3)
	lnH=MOD((19*lnA+lnB-lnP-lnG+15),30)
	lnI=INT(lnC/4)
	lnK=MOD(lnC,4)
	lnR=MOD((32+2*lnE+2*lnI-lnH-lnK),7)
	lnN=INT((lnA+11*lnH+22*lnR)/451)
	lnM=INT((lnH+lnR-7*lnN+114)/31)
	lnJ=MOD((lnH+lnR-7*lnN+114),31)+1
	RETURN RIGHT("00"+ALLTRIM(STR(lnJ,2)),2)+"/"+RIGHT("00"+ALLTRIM(STR(lnM,2)),2)+"/"+ALLTRIM(STR(tnAn,4))

ENDFUNC

*************************************************************************************

FUNCTION lse_DecaleDateSec(tdDate)

	* Dcalage de la date de 3 jours hors jours fris

	* tdDate	Date recherche

	LOCAL ldDate

	ldDate=tdDate
	ldDate=lse_DecaleDate(ldDate,-1,gcFerme1,gcFerme2,@gaFerie,gnMax)
	ldDate=lse_DecaleDate(ldDate,-1,gcFerme1,gcFerme2,@gaFerie,gnMax)
	ldDate=lse_DecaleDate(ldDate,-1,gcFerme1,gcFerme2,@gaFerie,gnMax)

	RETURN ldDate

ENDFUNC

*************************************************************************************

FUNCTION lse_DecaleDateX(tdDate,tnJours,tnSens)

	* Dcalage de la date de 3 jours hors jours fris

	* tdDate	Date recherche
	* tnJours   Nombre de jours de dcalage
	* tnSens	Sens du dcalage (-1 -> J-1, 1 pour J+1)

	LOCAL ldDate,lnI

	ldDate=tdDate
	tnJours=IIF(tnJours=0,1,tnJours)
	tnSens=IIF(tnSens=0,-1,tnSens)
	FOR lnI=1 TO tnJours
		ldDate=lse_DecaleDate(ldDate,tnSens,gcFerme1,gcFerme2,@gaFerie,gnMax)
	ENDFOR

	RETURN ldDate

ENDFUNC

*************************************************************************************

FUNCTION lse_Code128(tcCodeCps)

	LOCAL lnI,lnCheckSum,lnMini,lnDummy,lbTableB,lc_code128,lcChaineCode

	lc_code128=""
	lcChaine=ALLTRIM(tcCodeCps)
	lcChaineCode=lcChaine
	IF !EMPTY(lcChaine) 
		* Vrification des caractres : pas de code ascii inferieur  32 ou supperieur  126
		FOR lnI = 1 TO LEN(lcChaineCode)
			IF  !BETWEEN(ASC(SUBSTR(lcChaineCode, lnI,1)),32,126)
				lnI=0
				EXIT
			ENDIF
		ENDFOR
		* Calcul la chaine de code en optimisant l'usage des tables B et C
		lc_code128=""
		lbTableB=.T.
		IF lnI>0
			* VarI devient l'index sur la chaine
			lnI=1
			DO WHILE lnI<=LEN(lcChaineCode)
				IF lbTableB
					* Voir si intressant de passer en table C
					* Oui pour 4 chiffres au dbut ou  la fin, sinon pour 6 chiffres
					lnMini=IIF(lnI=1 OR lnI+3=LEN(lcChaineCode),4,6)
					*lnMini=
					IF Lse_Code128_TestNum(lcChaineCode,lnI,lnMini)<0	 	&& Choix table C
						IF lnI=1	 										&& Dbuter sur table C
							lc_code128=CHR(205)
						ELSE 												&& Commuter sur table C
							lc_code128=lc_code128+CHR(199)
						ENDIF
						lbTableB=.F.
					ELSE
						IF lnI=1
							lc_code128=CHR(204)
							*Dbuter sur table B
						ENDIF
					ENDIF
				ENDIF
				IF !lbTableB
					* On est sur la table C, essayer de traiter 2 chiffres
					lnMini= 2
					* lnMini=
					IF  Lse_Code128_TestNum(lcChaineCode,lnI ,lnMini)<0 
						* OK pour 2 chiffres, les traiter
						lnDummy=VAL(SUBSTR(lcChaineCode,lnI,2))
						lnDummy=IIF(lnDummy<95,lnDummy+32,lnDummy+100)
						lc_code128=lc_code128+CHR(lnDummy)
						lnI=lnI+2
					ELSE
						* On n'a pas 2 chiffres, repasser en table B
						lc_code128=lc_code128+CHR(200)
						lbTableB=.T.
					ENDIF
				ENDIF
				IF lbTableB
					* Traiter 1 caractre en table B
					lc_code128=lc_code128+SUBSTR(lcChaineCode,lnI,1)
					lnI=lnI+1
				ENDIF
				LOOP
			ENDDO
			*Calcul de la cl de contrle
			FOR lnI=1 TO LEN(lc_code128)
				lnDummy=ASC(SUBSTR(lc_code128,lnI,1))
				lnDummy=IIF(lnDummy<127,lnDummy-32,lnDummy-100)
				IF lnI=1
					lnCheckSum=lnDummy
				ELSE
					lnCheckSum=(lnCheckSum+(lnI-1)*lnDummy)%103
				ENDIF
			ENDFOR
			* Calcul du code ASCII de la cl
			lnCheckSum=IIF(lnCheckSum<95,lnCheckSum+32,lnCheckSum +100)
			* Ajout de la cl et du STOP
			lc_code128=lc_code128+CHR(lnCheckSum)+CHR(206)
		ENDIF
	ENDIF

	RETURN lc_code128

ENDFUNC

FUNCTION Lse_Code128_TestNum(tcCode,tnI,tnMini)

	* Si les tnMini caractres  partir de tnI sont numriques, alors tnMini=0

	tnMini=tnMini-1
	IF tnI+tnMini<=LEN(tcCode)
		DO WHILE tnMini>=0
			IF ASC(SUBSTR(tcCode,tnI+tnMini,1))<48 OR ASC(SUBSTR(tcCode,tnI+tnMini,1))>57
				EXIT
			ENDIF
			tnMini=tnMini-1
			LOOP
		ENDDO
	ENDIF
	RETURN tnMini

ENDFUNC

*************************************************************************************

FUNCTION Lse_ZopLibelle(zopnom,zopvalue)

	IF TYPE("zopvalue")!="C"
		RETURN ""
	ELSE
		RETURN IIF(IIF(EMPTY(zopvalue),.F.,rech("cod",PADR(IIF(rech("rub",zopnom,"rubnom"),rub.rubcodtpr," "),20," ")+zopvalue,"codcle_rm")),cod.coddesig," ")
	ENDIF

ENDFUNC


*************************************************************************************
